<?php
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    */

    include "../../include/includeBaseControllerComponenti.php";
    include "../classi/Contatore.php";
    
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
        $contatore = new Contatore($geecomDb, filter_input(INPUT_POST, "id"));
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
        $contatore = new Contatore($geecomDb, filter_input(INPUT_GET, "id"));
    }
    
    switch ($operazione) {
        case 'crea':
            $contatore->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $contatore->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $contatore->crea();
            header("Location: ../creaContatore.php?id={$contatore->getId()}&status=200");
            break;
        case 'modifica':
            $contatore->setNome(filter_input(INPUT_POST,"nome",FILTER_SANITIZE_ADD_SLASHES));
            $contatore->setSpazioOccupato(filter_input(INPUT_POST,"spazioOccupato",FILTER_SANITIZE_STRING));
            $contatore->modifica();
            header("Location: ../creaContatore.php?id={$contatore->getId()}&status=250");
            break;
        case 'elimina':
            $contatore->elimina();
            echo "ok";
            break;
        case 'duplica':
            $contatore->caricaDatiDalDatabase();
            $idNuovaForm = $contatore->duplica();
            header("Location: ../creaContatore.php?id={$idNuovaForm}&status=260");
            break;
        case 'duplicaElemento':
            $idNuovoElemento = $contatore->duplicaElemento(filter_input(INPUT_GET, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            header("Location: ../creaElemento.php?id={$idNuovoElemento}&status=210");
            break;
        case 'stampaElementi':
            $contatore->stampaElementi();
            break;
        case 'creaElemento':
            $nome   = filter_input(INPUT_POST, "nome",FILTER_SANITIZE_STRING);
            $numero = filter_input(INPUT_POST, "numero",FILTER_SANITIZE_STRING);
            $icona  = filter_input(INPUT_POST, "icona",FILTER_SANITIZE_STRING);
            $contatore->creaElemento($nome,$numero,$icona);
            echo "ok";
            break;
        case 'spostaElemento':
            $contatore->spostaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT),filter_input(INPUT_POST, "posizione",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
        case 'modificaElemento':
            $idElemento = filter_input(INPUT_POST,"idElemento",FILTER_SANITIZE_STRING);
            $etichetta  = filter_input(INPUT_POST,"etichetta",FILTER_SANITIZE_STRING);
            $valore     = filter_input(INPUT_POST,"valore",FILTER_SANITIZE_NUMBER_INT);
            $icona      = filter_input(INPUT_POST,"icona",FILTER_SANITIZE_STRING);
            $colore     = filter_input(INPUT_POST,"colore",FILTER_SANITIZE_STRING);
            $dimensioneIcona = filter_input(INPUT_POST,"dimensioneIcona",FILTER_SANITIZE_STRING);
            $contatore->modificaElemento($idElemento,$etichetta, $valore, $icona,$dimensioneIcona,$colore);
            header("Location: ../creaElemento.php?id={$idElemento}&status=200");
            break;
        case 'modificaImmagineElemento':
            $idElemento      = filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT);
            $tipiFileAmmessi = array("image/png","image/jpeg","image/gif");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../../../../immagini/slider", 0, $categoria->getNome());
            $esitoUpload  = $gestoreUpload->salvaFile();
            if($esitoUpload["fileElaborati"]==1) {
                if($esitoUpload["percorso"]!="") {
                    $percorsoFoto = str_replace("../","",$esitoUpload["percorso"]);
                }
                // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
                if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                    $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                    if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                        $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                    }
                }
            }
            else {
                $percorsoFoto = "";
            }
            $contatore->cambiaImmagineElemento($idElemento,$percorsoFoto);
            
            // se nelle impostazioni è spuintata la voce  "ottimizza immagini caricate" viene modificata
            if($impostazioni["ottimizzaImmaginiCaricate"]=="si") {
                $elaboratoreImmagini = new ElaboratoreImmagini($esitoUpload["percorso"]);
                if($elaboratoreImmagini->getAltezza()>$impostazioni["altezzaImmagine"]) {
                    $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaImmagine"], $esitoUpload["percorso"]);
                }
            }

            if($impostazioni["generaThumbnail"]=="si") {
                $percorsoFileThumbnail = str_replace("immagini/","immagini/thumbnail/",$esitoUpload["percorso"]);
                $percorsoThumbnail = str_replace("../","",$percorsoFileThumbnail);
                $elaboratoreImmagini->modificaInScala("altezza", $impostazioni["altezzaThumbnail"], $percorsoFileThumbnail);
            }
            
            echo "../../../$percorsoFoto";
            break;
        case 'eliminaElemento':
            $contatore->eliminaElemento(filter_input(INPUT_POST, "idElemento",FILTER_SANITIZE_NUMBER_INT));
            echo "ok";
            break;
    }
